/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.mixin;

import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.api.RaiderNameManager;
import io.github.overlordsiii.villagernames.api.VillagerNameManager;
import io.github.overlordsiii.villagernames.util.VillagerUtil;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1640;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3763;
import net.minecraft.class_3850;
import net.minecraft.class_3851;
import net.minecraft.class_3852;
import net.minecraft.class_3988;
import net.minecraft.class_4094;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1646.class})
public abstract class VillagerEntityMixin
extends class_3988
implements class_4094,
class_3851,
VillagerNameManager {
    private String firstName = null;
    private String fullName = null;
    private String lastName = null;
    private String profession = null;
    private String playerName = null;

    public VillagerEntityMixin(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"setVillagerData"}, at={@At(value="TAIL")})
    private void changeText(class_3850 villagerData, CallbackInfo ci) {
        if (!this.method_16914()) {
            VillagerUtil.createVillagerNames((class_1646)this);
        }
        if (villagerData.method_16924() != class_3852.field_17051 && this.method_16914()) {
            VillagerUtil.addProfessionName((class_1646)this);
        }
        if (this.method_16914() && villagerData.method_16924() == class_3852.field_17051) {
            VillagerUtil.updateLostVillagerProfessionName((class_1646)this);
        }
    }

    @Redirect(method={"onStruckByLightning"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/mob/WitchEntity;setCustomName(Lnet/minecraft/text/Text;)V"))
    private void redirectWitchConversion(class_1640 witchEntity, class_2561 name) {
        RaiderNameManager.setFirstName((class_3763)witchEntity, this.getFirstName());
        if (VillagerNames.CONFIG.villagerGeneralConfig.surNames) {
            RaiderNameManager.setLastName((class_3763)witchEntity, this.getLastName());
        }
        if (this.playerName != null) {
            RaiderNameManager.setPlayerName((class_3763)witchEntity, this.playerName);
        }
    }

    @Redirect(method={"onDeath"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;info(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"))
    private void redirectLogCallOnDeath(Logger logger, String s, Object o, Object o1) {
        if (VillagerNames.CONFIG.villagerGeneralConfig.turnOffVillagerConsoleSpam) {
            String string = "ha lol";
        } else {
            logger.info(s, o, o1);
        }
    }

    @Inject(method={"onGrowUp"}, at={@At(value="TAIL")})
    private void updateBabyText(CallbackInfo ci) {
        VillagerUtil.updateGrownUpVillagerName((class_1646)this);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void serializeData(class_2487 tag, CallbackInfo ci) {
        if (this.firstName != null) {
            tag.method_10582("firstName", this.firstName);
        }
        if (this.fullName != null) {
            tag.method_10582("fullName", this.fullName);
        }
        if (this.lastName != null) {
            tag.method_10582("lastName", this.lastName);
        }
        if (this.profession != null) {
            tag.method_10582("profession", this.profession);
        }
        if (this.playerName != null) {
            tag.method_10582("playerName", this.playerName);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void deserializeData(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("firstName")) {
            this.firstName = tag.method_10558("firstName");
        }
        if (tag.method_10545("fullName")) {
            this.fullName = tag.method_10558("fullName");
        }
        if (tag.method_10545("lastName")) {
            this.lastName = tag.method_10558("lastName");
        }
        if (tag.method_10545("profession")) {
            this.profession = tag.method_10558("profession");
        }
        if (tag.method_10545("playerName")) {
            this.playerName = tag.method_10558("playerName");
        }
    }

    @Override
    public void setPlayerName(String name) {
        this.playerName = name;
    }

    @Override
    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.updateFullName();
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.updateFullName();
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getProfessionName() {
        return this.profession;
    }

    @Override
    public void removeProfessionName() {
        this.profession = null;
        this.updateFullName();
    }

    @Override
    public void setProfessionName(String appendedProfession) {
        this.profession = appendedProfession;
        this.updateFullName();
    }

    @Override
    public String getFullName() {
        if (this.playerName != null) {
            return this.playerName;
        }
        return this.fullName;
    }

    @Override
    public void updateFullName() {
        StringBuilder builder = new StringBuilder();
        Objects.requireNonNull(this.firstName);
        if (VillagerNames.CONFIG.villagerGeneralConfig.reverseLastNames && VillagerNames.CONFIG.villagerGeneralConfig.surNames && this.lastName != null) {
            builder.append(this.lastName).append(" ").append(this.firstName);
        } else if (VillagerNames.CONFIG.villagerGeneralConfig.surNames && this.lastName != null) {
            builder.append(this.firstName).append(" ").append(this.lastName);
        } else {
            builder.append(this.firstName);
        }
        if (((class_1646)this).method_6109() && VillagerNames.CONFIG.villagerGeneralConfig.childNames) {
            builder.append(" the Child");
        } else if (VillagerNames.CONFIG.villagerGeneralConfig.professionNames && this.profession != null && !this.profession.equals("None")) {
            builder.append(" the ").append(this.profession);
        }
        this.fullName = builder.toString();
    }
}

